#ifndef ODESPHERE_H_
#define ODESPHERE_H_

#include "IPhysicalSphere.h"
#include <ode/ode.h>
namespace PhysicsEngine
{

class ODESphere : public PhysicsEngine::IPhysicalSphere
{
public:
	ODESphere();
	ODESphere(dWorldID world, int objectid, float radius, Vector3f position,Vector3f rotation, int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity);
	virtual ~ODESphere();
	void UpdateData();
	dGeomID GetGeomId();
	DataSphere *GetDataSphere();
	dWorldID GetWorldId();
	void SetWorldId(dWorldID world);
	void RotateObject(float axis_x, float axis_y, float axis_z, float angle);
	void SetPhysicalPosition(float posx, float posy, float posz);
	Vector3f GetAngularVelocity();
	Vector3f GetLinearVelocity();
private:
	dGeomID bodyid;
	dWorldID world;	
};

}

#endif /*ODESPHERE_H_*/
